% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\name{db_ts_get_dataset}
\alias{db_ts_get_dataset}
\title{Find Datasets Given a Set}
\usage{
db_ts_get_dataset(con, ts_keys, schema = "timeseries")
}
\arguments{
\item{con}{RPostgres connection object.}

\item{ts_keys}{\strong{character} vector of time series identifiers.}

\item{schema}{\strong{character} name of the database schema. Defaults to 'timeseries'}
}
\value{
data.frame with columns `ts_key` and `set_id`
}
\description{
Return set identifiers associated with a vector of keys. If a ts key does not exist in the catalog, set_id will be NA.
}
\examples{

\dontrun{

# one key
db_ts_get_dataset(
  con = connection,
  ts_keys = "ch.zrh_airport.departure.total",
  schema = "schema"
)

# multiple keys
db_ts_get_dataset(
  con = connection,
  ts_keys = c(
    "ch.zrh_airport.departure.total",
    "ch.zrh_airport.arrival.total"
  ),
  schema = "schema"
)
}
}
\seealso{
Other datasets functions: 
\code{\link{db_dataset_create}()},
\code{\link{db_dataset_delete}()},
\code{\link{db_dataset_get_keys}()},
\code{\link{db_dataset_get_last_update}()},
\code{\link{db_dataset_list}()},
\code{\link{db_dataset_trim_history}()},
\code{\link{db_dataset_update_metadata}()},
\code{\link{db_ts_assign_dataset}()}
}
\concept{datasets functions}
