% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_time_series.R
\name{db_ts_read_history}
\alias{db_ts_read_history}
\title{Read the Entire History of a Time Series}
\usage{
db_ts_read_history(
  con,
  ts_key,
  respect_release_date = FALSE,
  schema = "timeseries"
)
}
\arguments{
\item{con}{RPostgres connection object.}

\item{ts_key}{character The identifier of the time series to read.}

\item{respect_release_date}{\strong{boolean} indicating if it should the release embargo of a time series be respected. Defaults to FALSE. This option makes sense when the function is used in an API. In that sense, users do not have direct access to this function and therefore cannot simply switch parameters.}

\item{schema}{\strong{character} name of the database schema. Defaults to 'timeseries'}
}
\description{
This function returns a list whose keys correspond to the date on which the
contained version of the time series took effect.
}
\examples{

\dontrun{

# Storing different versions of the data, use parameter valid_from
# different versions are stored with the same key
ch.kof.barometer <- kof_ts["baro_2019m11"]
names(ch.kof.barometer) <- c("ch.kof.barometer")
db_ts_store(con = connection,
                  ch.kof.barometer,
                  valid_from = "2019-12-01",
                  schema = "schema")

ch.kof.barometer <- kof_ts["baro_2019m12"]
names(ch.kof.barometer) <- c("ch.kof.barometer")
db_ts_store(con = connection,
                  ch.kof.barometer,
                  valid_from = "2020-01-01",
                  schema = "schema")

# Reading all versions
db_ts_read_history(con = connection,
                         ts_key = "ch.kof.barometer",
                         schema = "schema")
}
}
\seealso{
Other time series functions: 
\code{\link{db_collection_read_ts}()},
\code{\link{db_dataset_read_ts}()},
\code{\link{db_ts_delete_latest_version}()},
\code{\link{db_ts_delete}()},
\code{\link{db_ts_get_last_update}()},
\code{\link{db_ts_read}()},
\code{\link{db_ts_store}()},
\code{\link{db_ts_trim_history}()}
}
\concept{time series functions}
