% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/store_time_series.R
\name{db_ts_store}
\alias{db_ts_store}
\title{Store a Time Series to the Database}
\usage{
db_ts_store(
  con,
  x,
  access = NULL,
  valid_from = NULL,
  release_date = NULL,
  pre_release_access = NULL,
  schema = "timeseries"
)
}
\arguments{
\item{con}{RPostgres connection object.}

\item{x}{Object containing time series to store. Single ts or xts objects are allowed as well as objects of type list, tslist, and data.table.}

\item{access}{character Access level for all ts to be stored. If set to NA (default) the database set it to 'main' access.}

\item{valid_from}{character representation of a date in the form of 'YYYY-MM-DD'. valid_from starts a new version}

\item{release_date}{character date from which on this version of the time series should be made available when release date is respected. Applies to all time series in x.}

\item{pre_release_access}{character Only allow access to the series being stored ahead of the release date to users with this access level. NULL (default) allows everybody. See respect_release_date in \code{\link{db_ts_read}}.}

\item{schema}{\strong{character} name of the database schema. Defaults to 'timeseries'}
}
\description{
Stores one or more time series to the database.
}
\examples{

\dontrun{
# storing zrh_airport data that is a list with two xts objects.
db_ts_store(con = connection, zrh_airport, schema = "schema")

# to store different versions of the data, use parameter valid_from
# different versions are stored with the same key
ch.kof.barometer <- kof_ts["baro_2019m11"]
names(ch.kof.barometer) <- c("ch.kof.barometer")
db_ts_store(
  con = connection,
  ch.kof.barometer,
  valid_from = "2019-12-01",
  schema = "schema"
)

ch.kof.barometer <- kof_ts["baro_2019m12"]
names(ch.kof.barometer) <- c("ch.kof.barometer")
db_ts_store(
  con = connection,
  ch.kof.barometer,
  valid_from = "2020-01-01",
  schema = "schema"
)
}
}
\seealso{
Other time series functions: 
\code{\link{db_collection_read_ts}()},
\code{\link{db_dataset_read_ts}()},
\code{\link{db_ts_delete_latest_version}()},
\code{\link{db_ts_delete}()},
\code{\link{db_ts_get_last_update}()},
\code{\link{db_ts_read_history}()},
\code{\link{db_ts_read}()},
\code{\link{db_ts_trim_history}()}
}
\concept{time series functions}
