% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scripts.R
\name{prScript}
\alias{prScript}
\title{create and/or open R scripts}
\usage{
prScript(name, template, subdir = ".", instructions = TRUE)
}
\arguments{
\item{name}{(optional) name of the script to create and/or open. This parameter can also include
the subfolder where to save the script (see examples).}

\item{template}{(Optional) One of "analysis", "data" or "function". Template to use for the
creation of a script. \code{prScript} adds a few comments that encourage the user to add
comments and explain what the script will do. These comments depend on the
choosen template. If the argument is missing, the choosen template depends
on the name of the script: "data" if the name begins with "data", "function"
if it start with "tools" and "analysis" in all other cases.}

\item{subdir}{subdirectory where the scripts needs to be created or opened. The 
subdirectory can also be directly specified in the parameter \code{name}.}

\item{instructions}{Should the created script include some instructions?}
}
\description{
\code{prScript} creates and opens a new script for edition. If the script
already exists, it opens it in the Rstudio editor.
}
\details{
If the parameter \code{name} is missing, then a list of existing scripts is
displayed. The user is then invited to choose one by typing the number or 
name of the script he wants to open.
}
\examples{
projectPath <- file.path(tempdir(), "test")
prInit(projectPath)

prScript("test")
list.files(projectPath, recursive = TRUE, include.dirs = TRUE)

prScript("myFunction", template = "function")

# Create script in a subfolder
prScript("test", subdir = "testdir")

# Or equivalently
prScript("testdir/test")

}
\seealso{
\code{\link{prSource}}, \code{\link{prMoveScript}}, \code{\link{prRenameScript}}, 
\code{\link{prDeleteScript}}
}
