% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrap_documents.r
\name{wrap_documents}
\alias{wrap_documents}
\title{Wrap tokens into document html strings}
\usage{
wrap_documents(
  tokens,
  meta,
  doc_col = "doc_id",
  token_col = "token",
  space_col = NULL,
  nav = doc_col,
  token_nav = NULL,
  top_nav = NULL,
  thres_nav = NULL
)
}
\arguments{
\item{tokens}{A data.frame with a column for document ids (doc_col)
and a column for tokens (token_col)}

\item{meta}{A data.frame with a column for document_ids (doc_col). All other columns are added
to the browser as document meta}

\item{doc_col}{The name of the document id column}

\item{token_col}{The name of the token column}

\item{space_col}{Optionally, a column with space indications (e.g., newline) per token (which is how some NLP parsers indicate spaces)}

\item{nav}{The column in meta used for nav. Defaults to 'doc_id'}

\item{token_nav}{Alternative to nav (which uses meta), a column in tokens used for navigation}

\item{top_nav}{If token_nav is used, navigation filters will only apply to the top x values with highest token occurence in a document}

\item{thres_nav}{Like top_nav, but specifying a threshold for the minimum number of tokens.}
}
\value{
A named vector, with document ids as names and the document html strings as values
}
\description{
Pastes the tokens into articles, and returns an <article> html element.
}
\examples{
docs = wrap_documents(sotu_data$tokens, sotu_data$meta)
head(names(docs))
docs[[1]]
}
