% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_csv.R
\name{load_csv}
\alias{load_csv}
\alias{load_tsv}
\alias{load_rds}
\alias{load_rdata}
\title{Import multiple common files from a directory into an environment.}
\usage{
load_csv(
  path = ".",
  regexp = "[.]csv$",
  ignore.case = TRUE,
  invert = FALSE,
  envir = .GlobalEnv,
  ...
)

load_tsv(
  path = ".",
  regexp = "[.]tsv$",
  ignore.case = TRUE,
  invert = FALSE,
  envir = .GlobalEnv,
  ...
)

load_rds(
  path = ".",
  regexp = "[.]rds$",
  ignore.case = TRUE,
  invert = FALSE,
  envir = .GlobalEnv
)

load_rdata(
  path = ".",
  regexp = "[.]rdata$|[.]rda$",
  ignore.case = TRUE,
  invert = FALSE,
  envir = .GlobalEnv
)
}
\arguments{
\item{path}{A character vector of one path. Defaults to the working
directory.}

\item{regexp}{A regular expression (e.g. \verb{[.]csv$}) passed on to \code{\link[=grep]{grep()}} to filter paths.}

\item{ignore.case}{if \code{FALSE}, the pattern matching is \emph{case
      sensitive} and if \code{TRUE}, case is ignored during matching.}

\item{invert}{If \code{TRUE} return files which do \emph{not} match}

\item{envir}{an \code{\link[base]{environment}} or \code{NULL}.}

\item{...}{Arguments passed to \code{readr::read_csv()} or \code{readr::read_tsv()}.}
}
\value{
\code{invisible(path)}.
}
\description{
These functions wrap common use-cases of \code{\link[=load_any]{load_any()}}.
}
\examples{
(path_csv <- tor_example("csv"))
dir(path_csv)

load_csv(path_csv)
# Each file is now available in the global environment
csv1
csv2

(path_mixed <- tor_example("mixed"))
dir(path_mixed)

# Loading the data in an environment other than the global environment
e <- new.env()
load_rdata(path_mixed, envir = e)
# Each dataframe is now available in the environment `e`
e$lower_rdata
e$upper_rdata
}
\seealso{
Other functions to import files into an environment: 
\code{\link{load_any}()}

Other functions to import files of common formats: 
\code{\link{list_csv}()}
}
\concept{functions to import files into an environment}
\concept{functions to import files of common formats}
