% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc.R
\name{read_description_file}
\alias{read_description_file}
\title{Read DESCRIPTION File into a List}
\usage{
read_description_file(p = NULL)
}
\arguments{
\item{p}{The path to the DESCRIPTION file. If \code{NULL}, the function attempts to find the DESCRIPTION file by searching upwards from the current directory.}
}
\value{
A list where each element is a field from the DESCRIPTION file.
}
\description{
Reads the DESCRIPTION file of an R package and converts it into a list where each element corresponds to a field in the DESCRIPTION file.
}
\examples{
# Read DECRIPTION file from a specific path
graphics_pkg_dir <- system.file(package = "graphics")
graphics_pkg_descfile <- find_description_file(graphics_pkg_dir)
desc_list <- read_description_file(graphics_pkg_descfile)
str(desc_list)

\dontrun{
# Below example will only work if executed from a package directory
read_description_file()
}
}
\keyword{doc}
