% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/path.R
\name{xdg_config_home}
\alias{xdg_config_home}
\title{Get XDG_CONFIG_HOME}
\usage{
xdg_config_home(sep = "/", fallback = normalizePath(getwd(), winslash = sep))
}
\arguments{
\item{sep}{Path separator to be used on Windows}

\item{fallback}{Value to return as fallback (see details)}
}
\value{
The following algorithm is used to determine the returned path:
\enumerate{
\item If environment variable (EV) \code{XDG_CONFIG_HOME} exists, return its value
\item Else, if EV \code{HOME} exists, return \verb{$HOME/.config}
\item Else, if EV \code{USERPROFILE} exists, return \verb{$USERPROFILE/.config}
\item Else, return \verb{$fallback}
}
}
\description{
Return value for XDG_CONFIG_HOME as defined by the \href{https://specifications.freedesktop.org/basedir-spec/basedir-spec-latest.html}{XDG Base Directory Specification}
}
\examples{
xdg_config_home()
}
\seealso{
\code{\link[=xdg_data_home]{xdg_data_home()}}
}
\keyword{path}
