% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_adequacy.R
\name{ConfIntT}
\alias{ConfIntT}
\title{Confidence interval}
\usage{
ConfIntT(sol, Y, A, nb = 10000, alpha = 0.98)
}
\arguments{
\item{sol}{Trajectory's object. An object of type Trajectory.}

\item{Y}{Matrix. A matrix containing the variables in the model.}

\item{A}{Matrix. A matrix containing the time variable data.}

\item{nb}{An integer. The number of repetitions in the bootstrap method.}

\item{alpha}{A number. The degree of confidence of the interval.}
}
\value{
A vector of reals. The two bounds of the confidence interval given a
  degree of confidence.
}
\description{
Calculate the confidence interval of the probabilities with bootstrap
method. We have to specify the number of the repetitions of bootstrap and the
degree of confidence.
}
\examples{
data <- read.csv(system.file("extdata", "CNORM2gr.csv", package = "trajeR"))
data <- as.matrix(data)
sol <- trajeR(Y = data[, 2:6], A = data[, 7:11], degre = c(2, 2), Model = "CNORM", Method = "EM")
ConfIntT(sol, Y = data[, 2:6], A = data[, 7:11])
}
