% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectory.R
\name{TrajRotate}
\alias{TrajRotate}
\title{Rotate a trajectory}
\usage{
TrajRotate(trj, angle = 0, origin = c(0, 0), relative = TRUE)
}
\arguments{
\item{trj}{The trajectory to be rotated.}

\item{angle}{The angle of rotation in radians. Either the first and last
points in the rotated trajectory (when \code{relative = TRUE}), or else the
angle be rotated (when \code{relative = FALSE}).}

\item{origin}{Trajectory is rotated about this point.}

\item{relative}{If TRUE, \code{angle} is the angle (after rotation) from the
start to the end point of the trajectory. If FALSE, the trajectory is
rotated about its start point by \code{angle}. You probably want to use
\code{relative = TRUE}.}
}
\value{
A new trajectory which is a rotated version of the input trajectory.
}
\description{
Rotates a trajectory by \code{angle} (when \code{relative} is \code{FALSE}),
or so that \code{angle(finish - start) == angle} (when \code{relative} is
\code{TRUE}).
}
