% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdist.R
\name{hdist}
\alias{hdist}
\alias{hdist.sfc}
\alias{hdist.sf}
\alias{hdist.stars}
\alias{hdist.transfR}
\title{Geographical distance between catchments}
\usage{
hdist(x, y, ...)

\method{hdist}{sfc}(
  x,
  y,
  method = "rghosh",
  gres = 5,
  ditself = FALSE,
  maxsample = 25000,
  proj = NULL,
  parallel = FALSE,
  cores = NULL,
  verbose = TRUE,
  ...
)

\method{hdist}{sf}(x, y, ...)

\method{hdist}{stars}(x, y, ...)

\method{hdist}{transfR}(x, y, method = "rghosh", weightO = 0.8, weightC = 0.2, ...)
}
\arguments{
\item{x}{sf, stars or transfR object of the first catchments}

\item{y}{sf, stars or transfR object of the second catchments}

\item{...}{further arguments passed to or from other methods}

\item{method}{the method to use for computing distance. This must be one of "ghosh",
"rghosh", "points", "centroids", "combined"}

\item{gres}{resolution of spatial discretisation (number of points by km²) for Ghosh
distance}

\item{ditself}{logical value indicating if the distance to itself should be computed.
It will add one row and one column in the distance matrix. Only used if method is "ghosh"}

\item{maxsample}{maximum size of sampling points for each catchments during spatial discretisation}

\item{proj}{logical indicating if spatial layer are using a projection. If TRUE, euclidean
distance is used. If FALSE, the great-circle distance is used}

\item{parallel}{logical indicating whether the computation should be parallelised. Could be a vector
of length two to distinguish between parallelisation of sampling and Ghosh distance
(because sampling over large areas can be memory intensive)}

\item{cores}{the number of cores to use for parallel execution if \code{parallel} is TRUE.
If not specified, the number of cores is set to the value of \code{parallel::detectCores()}.
Similarly to \code{parallel}, it could be a vector of length two to distinguish between
parallelisation of sampling and Ghosh distance}

\item{verbose}{boolean indicating if information messages should be written to the console}

\item{weightO}{weight given to the distance between outlets if method is "combined"}

\item{weightC}{weight given to the distance between centroids if method is "combined"}
}
\value{
A matrix of class units with the catchments of \code{x} organised in rows
and the catchments of \code{y} organised in columns.
}
\description{
Calculate distances between two sets of catchments using their spatial support.
}
\details{
The \code{method} "ghosh" refers to a simplification of the distance defined
by \insertCite{Ghosh1951;textual}{transfR} as proposed by \insertCite{Gottschalk1993,Gottschalk2011;textual}{transfR}.
The rescaled Ghosh distance (\code{method} "rghosh") is calculated following \insertCite{deLavenne2016;textual}{transfR}.
}
\examples{
data(Oudon)
catchments <- st_geometry(Oudon$obs)
hdist(x = catchments[1:2], y = catchments[3:5], gres = 5, method = "rghosh",
parallel=c(FALSE, TRUE), cores=2)
}
\references{
\insertRef{Ghosh1951}{transfR}

\insertRef{Gottschalk1993}{transfR}

\insertRef{Gottschalk2011}{transfR}

\insertRef{deLavenne2016}{transfR}
}
