% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_data.R
\name{generate_data}
\alias{generate_data}
\title{Generate data for simulation.}
\usage{
generate_data(n, alpha, rho, beta_true, now_repeat = 1)
}
\arguments{
\item{n}{number of subjects}

\item{alpha}{parameter in transformation function}

\item{rho}{parameter in baseline cumulative hazard function \eqn{\Lambda(t) =
\rho log(1+t)} assumed in simulation}

\item{beta_true}{parameter \eqn{\beta}}

\item{now_repeat}{number of duplication of simulation}
}
\value{
a list containing
\tabular{lccl}{
  \code{X} \tab\tab\tab design matrix \cr
  \code{beta_X} \tab\tab\tab \eqn{X\cdot\beta^T} \cr
  \code{Y} \tab\tab\tab observed event time \cr
}
}
\description{
Generate observed event times, covariates and other data used
  for simulations in the paper.
}
\details{
The survival function for \eqn{t} of the \eqn{i}th observation takes
the form \deqn{S_{i}(t| X_{i}) = \exp\left\{-H \{\Lambda(t) \exp ( \beta^T
X_{i} ) \}\right\}.} The failure time \eqn{T_i} can be generated by \deqn{
T_i = \left\{\begin{array}{l l} \exp\{
\frac{U^{-\alpha}-1}{\alpha\rho\exp\{\beta^TX_i \}} \}-1& \alpha > 0, \\
\exp\{  \frac{-log(U)}{\rho\exp\{\beta^TX_i \}} \}-1, & \alpha = 0.
\end{array}\right\} }
}
\examples{
 generate_data(200,0.5,1,c(0.5,-1))


}
\references{
Abramowitz, M., and Stegun, I.A. (1972). Handbook of Mathematical
  Functions (9th ed.). Dover Publications, New York.
+-
  Evans, M. and Swartz, T. (2000). Approximating Integrals via Monte Carlo
  and Deterministic Methods. Oxford University Press.

  Liu, Q. and Pierce, D.A. (1994). A note on Gauss-Hermite quadrature.
  Biometrika 81: 624-629.
}
