% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixSecondary.R
\name{fixSecondary}
\alias{fixSecondary}
\title{Interpolates secondary species concentration at missing time values}
\usage{
fixSecondary(conc, time, compTime, order = 2)
}
\arguments{
\item{conc}{Species concentration original vector.}

\item{time}{Times at which given concentrations were determined.}

\item{compTime}{Times at which the given species concentration must be
interpolated.}

\item{order}{Order of the polynomial to be fitted to data (1 or 2).
Default to 2.}
}
\value{
Vector of interpolated concentrations at times provided in
        \code{compTime}.
}
\description{
If the secondary species concentration is determined in just a fraction
of the aliquots and for some reason, the concentration in all the aliquots
is required or desired, the function fits a polynomial trend line to the
existing data and interpolates the concentration in missing aliquots.
}
\author{
Cristhian Paredes, \email{craparedesca@unal.edu.co}

Eduardo Rodriguez de San Miguel, \email{erdsmg@unam.mx}
}
