% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/egfr.R
\name{cockcroft_US}
\alias{cockcroft_US}
\title{Creatinine clearance by Cockcroft-Gault equation (US units)}
\usage{
cockcroft_US(creat, age, sex, weight)
}
\arguments{
\item{creat}{numeric vector of creatinine levels in mg/dl}

\item{age}{numeric vector of ages in years}

\item{sex}{character vector of sex ("F" = female, "M" = male)}

\item{weight}{numeric vector of weights in kilograms}
}
\value{
numeric vector of creatinine clearances in ml/min
}
\description{
A wrapper function for cockcroft(), a vectorised function to estimate creatinine clearance using the Cockcroft-Gault equation,
but using creatinine in mg/dl
}
\details{
Reference: Cockcroft DW, Gault MH. Prediction of creatinine clearance from serum creatinine.
Nephron 1976; 16(1):31-41
}
\examples{
cockcroft_US(creat = 1, age = 25, sex = "F", weight = 60)
}
