% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate.R
\name{generate_2d_n_arms_linked_star_data}
\alias{generate_2d_n_arms_linked_star_data}
\title{Generate a 2-dimensional linked star tree data}
\usage{
generate_2d_n_arms_linked_star_data(n_samples_vector, n_arms_vector, fatness)
}
\arguments{
\item{n_samples_vector}{The vector of the number of samples to be
generated. For example, \code{c(200, 100, 300)} means that the first
tree has 200 samples, the second tree has 100 samples and the
third tree has 300 samples.}

\item{n_arms_vector}{The vector of the number of arms to be
generated.  For example, \code{c(3, 2, 5)} means the first tree fits a
star tree with 3 arms, the second tree fits a star tree with 2
arms and the third tree fits a star tree with 5 arms. The size of
\code{n_arms_vector} must equal to the size of \code{n_samples_vector}.}

\item{fatness}{How fat from the based tree. \verb{[0.0, 1.0]} is
available value range.}
}
\value{
A generated \code{martix}. The rows and columns correspond to
samples and features.
}
\description{
Generate a 2-dimensional linked star tree data. Each
star tree data contain \code{n_samples_vector[i]} data points and fit
a star tree with \code{n_arms_vector[i]} arms.
}
\examples{
# Generate a 2-dimensional linked star tree data that contain
# 200-400-300 data points and fit a linked star tree with 3-5-4
# arms. The generated data are a bit noisy but tree-like.
linked_star.tree_like <-
  treefit::generate_2d_n_arms_linked_star_data(c(200, 400, 300),
                                               c(3, 5, 4),
                                               0.1)
plot(linked_star.tree_like)

# Generate a 2-dimensional linked star tree data that contain
# 300-200 data points and fit a linked star tree with 4-3 arms.
# The generated data are very noisy and less tree-like.
linked_star.less_tree_like <-
  treefit::generate_2d_n_arms_linked_star_data(c(300, 200),
                                               c(4, 3),
                                               0.9)
plot(linked_star.less_tree_like)

}
