% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unify_lightgbm.R
\name{lightgbm.unify}
\alias{lightgbm.unify}
\title{Unify LightGBM model}
\usage{
lightgbm.unify(lgb_model, data, recalculate = FALSE)
}
\arguments{
\item{lgb_model}{A lightgbm model - object of class \code{lgb.Booster}}

\item{data}{Reference dataset. A \code{data.frame} or \code{matrix} with the same columns as in the training set of the model. Usually dataset used to train model.}

\item{recalculate}{logical indicating if covers should be recalculated according to the dataset given in data. Keep it \code{FALSE} if training data are used.}
}
\value{
a unified model representation - a \code{\link{model_unified.object}} object
}
\description{
Convert your LightGBM model into a standardized representation.
The returned representation is easy to be interpreted by the user and ready to be used as an argument in \code{treeshap()} function.
}
\examples{
\donttest{
library(lightgbm)
param_lgbm <- list(objective = "regression", max_depth = 2,
                   force_row_wise = TRUE, num_iterations = 20)
data_fifa <- fifa20$data[!colnames(fifa20$data) \%in\%
             c('work_rate', 'value_eur', 'gk_diving', 'gk_handling',
             'gk_kicking', 'gk_reflexes', 'gk_speed', 'gk_positioning')]
data <- na.omit(cbind(data_fifa, fifa20$target))
sparse_data <- as.matrix(data[,-ncol(data)])
x <- lightgbm::lgb.Dataset(sparse_data, label = as.matrix(data[,ncol(data)]))
lgb_data <- lightgbm::lgb.Dataset.construct(x)
lgb_model <- lightgbm::lightgbm(data = lgb_data, params = param_lgbm,
                                verbose = -1, num_threads = 0)
unified_model <- lightgbm.unify(lgb_model, sparse_data)
shaps <- treeshap(unified_model, data[1:2, ])
plot_contribution(shaps, obs = 1)
}
}
\seealso{
\code{\link{gbm.unify}} for \code{\link[gbm:gbm]{GBM models}}

\code{\link{xgboost.unify}} for \code{\link[xgboost:xgboost]{XGBoost models}}

\code{\link{ranger.unify}} for \code{\link[ranger:ranger]{ranger models}}

\code{\link{randomForest.unify}} for \code{\link[randomForest:randomForest]{randomForest models}}
}
