% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_found.R
\name{get_found}
\alias{get_found}
\title{Get dataframe of tips that do not have congeners on tree.}
\usage{
get_found(absent_list, tree)
}
\arguments{
\item{absent_list}{Vector of taxa in the total dataset that are not on the tree}

\item{tree}{Starting tree; object of type phylo}
}
\value{
found_df Dataframe objects expressing the tips that are not
        on the tree, if they have congeners on the tree
}
\description{
Determine which tips that are not on the tree, and checks if they have congeners
on the tree.
}
\examples{
has_congeners <- treestartr:::get_found(absent_list, tree)
}
