% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rfun_psPwRtrigger.R
\name{psPwRtrigger}
\alias{psPwRtrigger}
\title{Powers of testing the primary and secondary hypotheses using trigger strategy}
\usage{
psPwRtrigger(
  alpha,
  alpha0,
  t0,
  t1,
  tc0 = t0,
  tc1 = t1,
  rho = 0,
  iuse0 = 1,
  iuse1 = 1,
  phi0 = rep(1, length(alpha)),
  phi1 = rep(1, length(alpha)),
  usingRhoForBoundary = FALSE,
  groupsize,
  szratio = 1,
  effsz0,
  effsz1
)
}
\arguments{
\item{alpha}{a number shows the overall error rate}

\item{alpha0}{a number shows the error rate assigned to the primary endpoint initially}

\item{t0}{a vector shows the information times of the primary endpoint}

\item{t1}{a vector shows the information times of the secondary endpoint}

\item{tc0}{a vector shows the calendar times of the primary endpoint}

\item{tc1}{a vector shows the calendar times of the secondary endpoint}

\item{rho}{a number shows the correlation between the primary and secondary endpoints}

\item{iuse0}{an integer shows the type of group sequential boundaries used for the primary endpoint}

\item{iuse1}{an integer shows the type of group sequential boundaries used for the secondary endpoint}

\item{phi0}{a parameter for the power family or the HSD gamma family for the primary endpoint}

\item{phi1}{a parameter for the power family or the HSD gamma family for the secondary endpoint}

\item{usingRhoForBoundary}{an indicator whether using the informaiton of rho to calculate the boundary, default is FALSE (not using)}

\item{groupsize}{a value of sample size in group 1}

\item{szratio}{a value of the sample size ratio, n2/n1}

\item{effsz0}{a value of effect size for hypothesis H0}

\item{effsz1}{a value of effect size for hypothesis H1}
}
\value{
a vector of two values of the probability that H0 is rejected, and the probability that H1 is rejected, using the trigger strategy
}
\description{
This function computes the powers of testing the primary and secondary hypotheses using trigger strategy.
}
\examples{
alpha <-  0.0250
alpha0 <- 0.0136
iuse0 <- 1
iuse1 <- 2
phi0 <- -4
phi1 <- 1
tc0 <- c(1,2)
tc1 <- c(1,2,3)
t0 <- c(0.6,1)
t1 <- c(0.5,0.9,1)
rho <- 0
effsz0 <- 0.33
effsz1 <- 0.30
groupsize=226
szratio=1
psPwRtrigger(alpha=alpha, alpha0=alpha0,
    t0=t0, t1=t1, tc0=tc0, tc1=tc1,
    rho=rho, iuse0=1, iuse1=iuse1,
    phi0=phi0, phi1=phi1,
    usingRhoForBoundary=FALSE,
    groupsize=groupsize, szratio=szratio,
    effsz0=effsz0, effsz1=effsz1)
}
\references{
Gou, J. (2023). Trigger strategy in repeated tests on multiple hypotheses. \emph{Statistics in Biopharmaceutical Research}, 15(1), 133-140.
Gou, J. (2022). Sample size optimization and initial allocation of the significance levels in group sequential trials with multiple endpoints. \emph{Biometrical Journal}, 64(2), 301-311.
}
