% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{update_prior}
\alias{update_prior}
\title{Calculate posterior distribution of the proportion of liars}
\usage{
update_prior(heads, N, P, prior = stats::dunif, npoints = 1000)
}
\arguments{
\item{heads}{Number of good outcomes reported}

\item{N}{Total number in sample}

\item{P}{Probability of \emph{bad} outcome}

\item{prior}{Prior over lambda. A function which takes a vector of values
between 0 and 1, and returns the probability density. The default is
the uniform distribution.}

\item{npoints}{How many points to integrate on?}
}
\value{
The probability density of the posterior distribution, as a one-argument
function.
}
\description{
\code{update_prior} uses the equation for the posterior:

\deqn{
  \phi(\lambda | R; N,P) = Pr(R|\lambda; N,P) \phi(\lambda) /
    \int Pr(R | \lambda'; N,P) \phi(\lambda') d \lambda'
}

where \eqn{\phi} is the prior and \eqn{Pr(R | \lambda; N, P)} is the
probability of R reports of heads given that people lie with probability
\eqn{\lambda}:

\deqn{
  Pr(R | \lambda; N, P) = binom(N, (1-P) + \lambda P)
}
}
\examples{
posterior <- update_prior(heads = 30, N = 50, P = 0.5, prior = stats::dunif)
plot(posterior)
}
