#'LT objective function
#'
#'
#'@param bet parameter values. Column matrix with p rows.
#'@param x model matrix
#'@param y response variable, column matrix
#'@param cl lower threshold value to be used, number or numeric vector of length 1.  (See \code{\link{lt}}, argument \code{clower}, for more information).
#'@param cu upper threshold value to be used, number or numeric vector of length 1. (See \code{\link{lt}}, argument \code{cupper}, for more information).
#'
#'@return
#'Returns the value of the objective function for given parameter values
#' 
#'@export
#'@author Anita Lindmark and Maria Karlsson
#'@seealso \code{\link{lt}}

funcval.LT <- function(bet,x,y,cl,cu) 		
{
  ind <- ifelse(x%*%bet>cl,(ifelse(-cl<=(y-x%*%bet)&(y-x%*%bet)<=cu,0.5*(y-x%*%bet)^2,0)+ifelse((y-x%*%bet)<(-cl),0.5*cl^2,0)
                            +ifelse((y-x%*%bet)>cu,0.5*cu^2,0)),(ifelse(-cl<=(y-cl)&(y-cl)<=cu,0.5*(y-cl)^2,0)+ifelse((y-cl)<(-cl),0.5*cl^2,0)
                                                                 +ifelse((y-cl)>cu,0.5*cu^2,0)))
  funcvalue <- sum(ind)
  return(funcvalue)
}