% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frequdom.r
\name{specest}
\alias{specest}
\title{\code{specest}  direct spectral estimation of series y
                             using periodogram window win}
\usage{
specest(
  y,
  nf,
  e,
  win = c("perwinba", "perwinpa", "perwinda"),
  conf = 0,
  type = "cov"
)
}
\arguments{
\item{y}{(n,1) vector, the ts}

\item{nf}{number of equally spaced frequencies}

\item{e}{equal bandwidth, must be 0 <= e <0.5}

\item{win}{string, name of periodogram window
(possible: "perwinba", "perwinpa", "perwinda")}

\item{conf}{scalar, the level for confidence intervals}

\item{type}{c("cov","cor"), area under spectrum is variance or is normed to 1.}
}
\value{
est  (nf+1,2)- or (nf+1,4)-matrix:   
\item{column 1:}{frequencies 0, 1/n, 2/n, ..., m/n }
\item{column 2:}{the estimated spectrum  }
\item{column 3+4:}{the confidence bounds   }
}
\description{
\code{specest}  direct spectral estimation of series y
                             using periodogram window win
}
\examples{
data(WHORMONE)
est <- specest(WHORMONE,50,0.05,win = c("perwinba","perwinpa","perwinda"),conf=0,type="cov") 

}
