% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adj.two.R
\name{adj.two}
\alias{adj.two}
\title{Zhong's 2-/3- stage Phase II design}
\usage{
adj.two(n1, r1, s1, n2, alpha1, alpha2, beta, pc, pe, ...)
}
\arguments{
\item{n1}{sample size at stage 1.}

\item{r1}{inefficacy boundary at stage 1.}

\item{s1}{efficacy boundary at stage 1. if no early stopping for efficacy, \code{s1} should equal to \code{n1}.}

\item{n2}{sample size at stage 2.}

\item{alpha1}{left-side overall type I error.}

\item{alpha2}{right-side overall type I error.}

\item{beta}{type II error.}

\item{pc}{a numeric vector of response rate. should be a vector with length 1 or 2.}

\item{pe}{alternative hypothesis.}

\item{...}{not used argument.}
}
\value{
An object of class "opt.design" is a list containing:
 \item{bdry}{rejection regions}
 \item{error}{true type 1/2 errors}
 \item{n}{sample size at each stage} 
 \item{complete}{complete list of feasible designs}
 \item{alpha1}{input; left-side type 1 error}
 \item{alpha2}{input; right-side type 1 error}
 \item{beta}{input; type 2 error}
 \item{pc}{input; a vector of response rate.}
 \item{pe}{input; a vector of alternative response rate}
 \item{sf}{input; the alpha-spending function used}
 \item{stage}{input; two- or three- stage design is used}
}
\description{
adjust Zhong's 2-/3-stage design for over-/under-running
}
\details{
To be added
}
\examples{
 n1 <- 22
 r1 <- 6
 s1 <- 22
 n2 <- 24
 pc <- 0.4
 pe <- pc + 0.15
 alpha1 <- 0.3
 alpha2 <- 0.1
 beta <- 0.2
 out <- adj.two(n1, r1, s1, n2, alpha1, alpha2, beta, pc, pe)
}
\author{
Wenchuan Guo <wguo1017@gmail.com>, Jianan Hui <jiananhuistat@gmail.com>
}
