% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsdisagg2.R
\name{tsdisagg2}
\alias{tsdisagg2}
\title{Time Series Disaggregation.}
\usage{
tsdisagg2(y, x, c = 0, method = "cl1", s = 4, type = "sum", ML = 0,
  rho, neg = 0, da, dz, plots = 0)
}
\arguments{
\item{y}{A data.frame, matrix, list or vector with low frequency data.}

\item{x}{A data.frame, matrix, list or vector with high frequency data.}

\item{c}{Constant; If c=1, the model will be estimated with a constant; If c=0, the opposite case. (Default: c=0)}

\item{method}{Set disaggregation method; Available methods are Boot, Feibes and Lisman (method="bfl1" or method="bfl2"), Chow and Lin (method="cl1" or method="cl2"), Fernandez (method="f") and Litterman (method="l"). Default: method="cl1"}

\item{s}{Frequency of observations; Available frequencies are 3, 4 or 12. For example, if s=4, we have quaterly observations. (Default: s=4)}

\item{type}{Type of restriction; Could be "last", "first", "sum" or "average". (Default: type="sum")}

\item{ML}{Maximum Likelihood (ML=1) or Generalised Least Squares (ML=0) "rho" estimation. (Default: ML=0)}

\item{rho}{Sets a value for "rho" (Default: rho=0)}

\item{neg}{If neg=1, will be tested negative for "rho"; If neg=0, only positive values will be tested. (Default: neg=0)}

\item{da}{First year considered on low frequency data.}

\item{dz}{Last year considered on low frequency data.}

\item{plots}{If plots=1, generates the plot of the estimated series and the plot withe Objective function values; If prints=0, the opposite case. (Default: plots=0)}
}
\value{
The function prints details of the disaggregation (smooth, loglik, ...), estimated parameters (sigma_ols, sigma_gls, model coefficients, ...) and the disaggregated series. The function also returns an invisible list containing all the numeric results.
}
\description{
The "tsdisagg2" function performs temporal disaggregation or interpolation of low frequency to high frequency time series.
}
\details{
The function is used  to disaggregate a low frequency to a higher frequency time series, while either the sum, the average, the first or the last value of the resulting high-frequency series is consistent with the low frequency series.
Implements the following methods for temporal disaggregation: Boot, Feibes and Lisman (first and second differences), Chow and Lin (independent and AR(1) errors), Fernandez and Litterman.
For Boot, Feibes and Lisman methods, the disaggregation can not be performed with help of indicator series. For the remaining methods, desaggregation can be performed with or without the help of one or more indicator series.
If the high-frequency indicator(s) cover(s) a longer time span than the low-frequency series, an extrapolation is performed, using the same model as for interpolation.
}
\examples{
anual <- runif( 19, 300, 455 )
indicators <- data.frame( runif( 76, 500, 700 ), runif( 76, 800, 980 ) )

### Constant ###

tsdisagg2( y=anual, x=indicators, c=1, da=1995, dz=2013, plots=1 )
# Estimate model with constant

### Method selection ###

tsdisagg2( y=anual, x=indicators, method="f", da=1995, dz=2013, plots=1 )
# Use option method

### "rho" value ###

tsdisagg2( y=anual, x=indicators, method="cl2", da=1995, dz=2013, plots=1 )
# Search for positive optimal "rho" is enabled (if method="cl2" or method="l")

tsdisagg2( y=anual, x=indicators, method="cl2", rho=0.35, da=1995, dz=2013, plots=1 )
# Set "rho" value manually (the grid search is not performed)

### Interpolation or distribution ###

tsdisagg2( y=anual, x=indicators, da=1995, dz=2013, method="f", type="last" )
# Performs disaggregation by interpolation with type="last" or type="first"

tsdisagg2( y=anual, x=indicators, da=1995, dz=2013, method="f", type="average" )
# Performs disaggregation by distribution with type="sum" or type="average"

### Use returned objects ###
td <- tsdisagg2( y=anual, x=indicators, da=1995, dz=2013, method="f", type="average" )
names(td)
td$BETA_ESTIMATION
}

