% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{forecast.peak}
\alias{forecast.peak}
\title{Returns forecast of number of periods until peak given estimated
state variables \eqn{\delta} and \eqn{\gamma}.}
\usage{
forecast.peak(delta, gamma)
}
\arguments{
\item{delta}{The estimate of \eqn{\delta}, the level of \eqn{\ln g}.}

\item{gamma}{The estimate of \eqn{\gamma}, the slope of \eqn{\ln g}.}
}
\value{
Forecast of number of periods until peak.
}
\description{
Since Harvey and Kattuman (2021) show that
\deqn{g_{y,t+\ell|T} = \exp\{\delta_{T|T}+\ell \gamma_{T|T}\}+\gamma_{T|T},}
we can compute the \eqn{\ell} for which \eqn{g_{y,t}=0} and then will fall
below zero. This \eqn{\ell} is given by
\deqn{\ell = \frac{\ln(-\gamma_{T|T})-\delta_{T|T}}{\gamma_{T|T}}.} This is
predicated on \eqn{\gamma_{T|T}<0}, else there is super-exponential growth an
no peak in sight. Of course, it only makes sense to investigate an upcoming
peak for \eqn{g_{y,T|T}>0} (when cases are growing).
}
\examples{
# Forecasts the peak of an epidemic with gamma < 0 so that a peak is in
# sight.
forecast.peak(-2.87,-0.045)

# Does not return a result (returns an error as gamma > 0)
try(forecast.peak(-2.87,0.045), silent=TRUE)

}
