% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{forecast_peak}
\alias{forecast_peak}
\title{Returns forecast of number of periods until peak given
\code{KFAS::KFS} output.}
\usage{
forecast_peak(kfs_out)
}
\arguments{
\item{kfs_out}{The \code{KFAS::KFS} object for which the forecast peak is to
be calculated. This would be the \code{output} element of a model estimated
in the \code{SSModelDynamicGompertz} or \code{SSModelDynamic}}
}
\value{
Forecast of number of periods until peak.
}
\description{
Since Harvey and Kattuman (2021) show that \deqn{g_{y,t+\ell|T}
= \exp\{\delta_{T|T}+\ell \gamma_{T|T}\}+\gamma_{T|T},} we can compute the
\eqn{\ell} for which \eqn{g_{y,t}=0} and then will fall below zero. This
\eqn{\ell} is given by
\deqn{\ell = \frac{\ln(-\gamma_{T|T})-\delta_{T|T}}{\gamma_{T|T}}.} This is
predicated on \eqn{\gamma_{T|T}<0}, else there is super-exponential growth
and no peak in sight. Of course, it only makes sense to investigate an
upcoming peak for \eqn{g_{y,T|T}>0} (when cases are growing). The estimates
of \eqn{\delta_{T|T}} and \eqn{\gamma_{T|T}} are extracted from the
\code{KFS} object passed to the function.
}
\examples{
library(tsgc)
data(gauteng,package="tsgc")
idx.est <- zoo::index(gauteng) <= as.Date("2020-07-06")

res <- SSModelDynamicGompertz$new(Y = gauteng[idx.est], q = 0.005)$estimate()

forecast_peak(res$output)

}
