% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_report.R
\name{get_report}
\alias{get_report}
\title{Get Reports}
\usage{
get_report(
  ids,
  metrics,
  start_date = NULL,
  end_date = NULL,
  currency = NULL,
  dimensions,
  filters,
  historical_channel_data = NULL,
  max_results = NULL,
  sort = NULL,
  start_index = NULL,
  user_ip = NULL,
  ...
)
}
\arguments{
\item{ids}{Named vector with two potential names: channel or contentOwner
If channel, potential values are: mine or channel_id
If contentOwner, potential values are: owner_id of the content}

\item{metrics}{String. Comma-separated list of YouTube Analytics metrics, such as \code{views} or \code{likes,dislikes}.}

\item{start_date}{String. Must be in YYYY-MM-DD format.}

\item{end_date}{String. Must be in YYYY-MM-DD format.}

\item{currency}{Optional. String. Default is USD. Specifies what earnings metrics like
\code{earnings, adEarnings, grossRevenue, playbackBasedCpm, impressionBasedCpm} will be reported in.}

\item{dimensions}{String. Optional. Comma-separated list of YouTube Analytics dimensions, such as \code{video} or \code{ageGroup,gender}.}

\item{filters}{Named Vector. Optional. For instance, ``\code{video==pd1FJh59zxQ,Zhawgd0REhA;country==IT}
restricts the result set to include data for the given videos in Italy''}

\item{historical_channel_data}{Boolean. Defaults is False.
``Whether the API response should include channels' watch time and view data from the time period prior
to when the channels were linked to the content owner.''}

\item{max_results}{Integer. Optional. The maximum number of rows to include in the response.}

\item{sort}{String. Optional A comma-separated list of dimensions or metrics that determine the sort order for YouTube}

\item{start_index}{Integer. Optional. ``The 1-based index of the first entity to retrieve.''}

\item{user_ip}{``IP address of the end user for whom the API call is being made.''}

\item{\dots}{Additional arguments passed to \code{\link[tubern]{tubern_GET}}.}
}
\value{
named list
}
\description{
Lists reporting jobs that have been scheduled for a channel or content owner.
}
\examples{
\dontrun{
get_report(ids = "channel==MINE", metrics = "views",
start_date = "2010-04-01", end_date ="2017-01-01")
}
}
\references{
\url{https://developers.google.com/youtube/analytics/v1/reference/reports/query}
}
