% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{package}
\name{tuple-package}
\alias{tuple-package}
\title{The tuple Package}
\description{
Find every match, or orphan, duplicate, triplicate, or other replicated values.

This package extends the base R functionality around checking
  for \code{\link[base]{unique}} and duplicate values in vectors.
}
\details{
\tabular{ll}{
Package: \tab tuple\cr
Type: \tab Package\cr
Version: \tab 0.4-02\cr
Date: \tab 2014-10-31\cr
Depends: \tab R (>= 2.10.0)\cr
Encoding: \tab UTF-8\cr
License: \tab LGPL-3\cr
LazyLoad: \tab no\cr
URL: \tab http://statistics.lazaridis.eu\cr
}

Functions to find all matches or non-matches, orphans, and duplicate or other replicated elements.

The following changes are documented since the first release
  of this package on CRAN:
\tabular{lll}{
Version \tab Change               \tab Description              \cr
0.3-06  \tab None                 \tab Initial release to CRAN. \cr
0.4-01  \tab Added \code{\link{\%!in\%}}                   \tab
    This function tests for the opposite of the commonly        \cr
\tab \tab used testing operator \code{"\%in\%"}
          as documented in \code{\link[base]{match}}.           \cr
        \tab Added documentation                           \tab
    Added documentation for the package as a whole.             \cr
\tab \tab Implemented this change log.                          \cr
        \tab Improved documentation                        \tab
    Cleaned and otherwise improved documentation                \cr
\tab \tab that is generated by way of the \pkg{roxygen2}
          package                                               \cr
\tab \tab for existing functions.                               \cr
        \tab Added \code{\link{tuplicated}}                \tab
    This function is a major addition to the package.           \cr
\tab \tab It provides a generic way to find elements of a       \cr
\tab \tab vector that are replicated n or more times.           \cr
\tab \tab Fundamentally it depends only on the code for         \cr
\tab \tab \code{\link{duplicated}} as in the first version
          of this                                               \cr
\tab \tab package released to CRAN. The implementation          \cr
\tab \tab of \code{\link{triplicated}} has not been changed
          in this                                               \cr
\tab \tab in this update from version 0.3-06, but it will be    \cr
\tab \tab changed to call \code{\link{tuplicated}}
          with \code{tuple = 3}                                 \cr
\tab \tab in a future release.                                  \cr
        \tab Added \code{\link{tuplicate}}                 \tab
    This function is another major addition. It provides        \cr
\tab \tab a generic way to find elements of a vector that are   \cr
\tab \tab replicated exactly n times. It depends on the code    \cr
\tab \tab for the newly-released
          \code{\link{tuplicated}}, and on the code             \cr
\tab \tab for \code{\link{orphan}} as in the initial package
          released to CRAN.                                     \cr
\tab \tab The implementation of
          \code{\link{triplicate}} has not changed              \cr
\tab \tab from version 0.3-06, but it will be changed to call   \cr
\tab \tab \code{\link{tuplicate}} with \code{tuple = 3}
          in a future release.                                  \cr
0.4-02  \tab Added \code{\link{matchNone}}                 \tab
    This function returns a character string, based             \cr
\tab \tab on the table, that does not appear in the data.       \cr
}
}
\author{
Emmanuel Lazaridis
}
\keyword{package}

