% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotRegion.R
\name{plotRegion}
\alias{plotRegion}
\title{Generic function to plot a shaded region around values of a scalar function.}
\usage{
plotRegion(x, mat,
           add=FALSE,xlim=range(x),ylim=range(mat),
           colfill="#D9D9D980",lwd=2,xlab="",ylab="",main="",...)
}
\arguments{
\item{x}{n-vector with a grid of x values where the scalar function f(x) is evaluated.}

\item{mat}{(n x 3)-matrix containing on its ith row, the function value at x[i] and the bounds of an interval containing it, (f(x[i]), f.low(x[i]), f.up(x[i])).}

\item{add}{logical indicating if the shaded region should be superposed to an existing plot.}

\item{xlim}{x-limits. (Default: range of x).}

\item{ylim}{y-limits. (Default: range of mat).}

\item{colfill}{color used for filling the shaded region. (Default: "#D9D9D980").}

\item{lwd}{line width to plot (x,f(x)). (Default: 2).}

\item{xlab}{x-label. (Default: none).}

\item{ylab}{y-label. (Default: none).}

\item{main}{plot main title. (Default: none)}

\item{...}{additional generic plotting arguments.}
}
\value{
No returned value (in addition to the plot).
}
\description{
Generic function to plot a shaded region around values of a scalar function.
}
\examples{
\donttest{
require(tvcure)
## Simulated data generation
beta = c(beta0=.4, beta1=-.2, beta2=.15) ; gam = c(gam1=.2, gam2=.2)
data = simulateTVcureData(n=500, seed=123, beta=beta, gam=gam,
                          RC.dist="exponential",mu.cens=550)$rawdata
## TVcure model fitting
tau.0 = 2.7 ; lambda1.0 = c(40,15) ; lambda2.0 = c(25,70) ## Optional
model = tvcure(~z1+z2+s(x1)+s(x2), ~z3+z4+s(x3)+s(x4), data=data,
               tau.0=tau.0, lambda1.0=lambda1.0, lambda2.0=lambda2.0)
obj = additive.tvcure(model) ## Extract additive terms

## Plot some of the fitted additive terms
## par(mfrow=c(1,2))
with(obj$f1.grid$x1, plotRegion(x=x,mat=y.mat,xlab="x1",ylab="f(x1)"))
with(obj$f1.grid$x2, plotRegion(x=x,mat=y.mat,xlab="x2",ylab="f(x2)"))
}

}
\references{
Lambert, P. and Kreyenfeld, M. (2025).
Time-varying exogenous covariates with frequently changing values in double additive cure survival model: an application to fertility.
\emph{Journal of the Royal Statistical Society, Series A}. <doi:10.1093/jrsssa/qnaf035>
}
\author{
Philippe Lambert \email{p.lambert@uliege.be}
}
