% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post_mcmc.R
\name{cross_dat_analy}
\alias{cross_dat_analy}
\title{Compares clustering across datasets using metrics described in associated TWL manuscript}
\usage{
cross_dat_analy(clus_save, BURNIN)
}
\arguments{
\item{clus_save}{list of samples outputted from TWLsample function.}

\item{BURNIN}{number of samples devoted to burn-in.  Defaults to 2000.}
}
\value{
outpu_lis a list of output metrics.  The first element is a list of lists of sample-specific pairwise cluster overlap.  The second element is an estimate of across all datasets cluster correspondence by averaging pairwise cluster overlap (the length is the vector therefore is the number of unique samples associated with at least 2 data sources.
}
\description{
Compares clustering across datasets using metrics described in associated TWL manuscript
}
\examples{
data(data_and_output)
\dontrun{clus_save <- TWLsample(misaligned_mat,misaligned,output_every=50,num_its=5000,manip=FALSE)
outpu_new <- pairwise_clus(clus_save,BURNIN=2000)
post_analy_cor(outpu_new,c("title1","title2","title3","title4","title5"),
tempfile(),ords='none') 
clus_labs <- post_analy_clus(outpu_new,clus_save,c(2:6),rep(0.6,5),c("title1","title2",
"title3","title4","title5"),tempfile())
output_nest <- cross_dat_analy(clus_save,4750)
}
}
