% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post_mcmc.R
\name{pairwise_clus}
\alias{pairwise_clus}
\title{Create posterior similarity matrix from outputted list of clustering samples}
\usage{
pairwise_clus(clus_save, BURNIN = 2000)
}
\arguments{
\item{clus_save}{list of samples outputted from TWLsample function.}

\item{BURNIN}{number of samples devoted to burn-in.  Defaults to 2000.}
}
\value{
outpu a list whose length is the number of datasets being integrated, and each elemnt of which is a posterior similarity matrix.  The dimension of each symmetric matrix is the number of samples in the respective dataset, and elements in the matrix are values between 0 and 1, and estimate of the probability 2 samples find themselves in the same clustering.
}
\description{
Create posterior similarity matrix from outputted list of clustering samples
}
\examples{
data(data_and_output)
\dontrun{clus_save <- TWLsample(misaligned_mat,misaligned,output_every=50,num_its=5000,manip=FALSE)
outpu_new <- pairwise_clus(clus_save,BURNIN=2000)
post_analy_cor(outpu_new,c("title1","title2","title3","title4","title5"),
tempfile(),ords='none') 
clus_labs <- post_analy_clus(outpu_new,clus_save,c(2:6),rep(0.6,5),c("title1","title2",
"title3","title4","title5"),tempfile())
output_nest <- cross_dat_analy(clus_save,4750)
}
}
