% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculFastSpectral_p.r
\name{cutCalculation}
\alias{cutCalculation}
\title{cutCalculation function}
\usage{
cutCalculation(similarity, label, K)
}
\arguments{
\item{similarity}{a similarity matrix.}

\item{label}{vector of cluster sequencing.}

\item{K}{number of clusters. (= nbCluster CALCULE DANS LA FONCTION ???)}
}
\value{
The function returns a list containing:
\item{mncut}{the inter-cluster cut, i.e. K-sum(ratioCutVol).}
\item{ratioCutVol}{vector of intra-cluster cuts, one component per cluster.}
}
\description{
Compute intra and inter-cluster cuts from the similarity matrix of a dataset.
}
\details{
intra cluster cut :
\deqn{Cut(g_{k},g_{l}) = \sum_{i=1,x(i)\in g_{k}}^{N_{p}}\sum_{j=1,x(j)\in g_{l}}^{N_{p}}w(x(i),x(j)) }
}
\examples{
x<-rbind(matrix(runif(100),ncol=2),matrix(runif(100)+2,ncol=2),matrix(runif(20)*3,ncol=2))
similarity<-ZPGaussianSimilarity(x,7)\%*\%t(ZPGaussianSimilarity(x,7))
km<-kmeans(similarity,2)
label<-km$cluster
plot(x,col=km$cluster)
cutCalculation(similarity,label,length(unique(label)))
}

