% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculFastSpectral_p.r
\name{spectralPamClusteringNg}
\alias{spectralPamClusteringNg}
\title{spectralPamClusteringNg function}
\usage{
spectralPamClusteringNg(similarity, K)
}
\arguments{
\item{similarity}{matrix of similarity}

\item{K}{number of clusters}
}
\value{
The function returns a list containing:
\item{label}{vector of cluster sequencing.}
\item{centres}{matrix of cluster medoids (similar in concept to means, but medoids are members of the dataset) in the space of the K first normalised eigen vectors.}
\item{id.med}{integer vector of indices giving the medoid observation numbers.} 
\item{vecteursPropresProjK}{matrix containing, in columns, the K first normalised eigen vectors of the similarity matrix.} 
\item{valeursPropresK}{vector containing the K first eigen values of the similarity matrix.} 
\item{vecteursPropres}{matrix containing, in columns, eigen vectors of the similarity matrix.} 
\item{valeursPropres}{vector containing eigen values of the similarity matrix.} 
\item{cluster.info}{matrix, each row gives numerical information for one cluster. 
These are the cardinality of the cluster (number of observations), 
the maximal and average dissimilarity between the observations in the cluster and the cluster's medoid, 
the diameter of the cluster (maximal dissimilarity between two observations of the cluster), 
and the separation of the cluster (minimal dissimilarity between an observation of the cluster and an observation of another cluster).}
}
\description{
Perform spectral classification on the similarity matrix of a dataset, using pam algorithm (a more robust version of K-means) on projected data.
}
\references{
Ng Andrew, Y., M. I. Jordan, and Y. Weiss. "On spectral clustering: analysis and an algorithm [C]." Advances in Neural Information Processing Systems (2001).
}
\seealso{
\code{\link[cluster]{pam}}
}

