% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bn.R
\name{bn}
\alias{bn}
\title{Computes Bn Statistic.}
\usage{
bn(group_id, md = NULL, data = NULL)
}
\arguments{
\item{group_id}{A vector of 0s and 1s indicating to which group the samples belong. Must be in the same order as data or md.}

\item{md}{Matrix of distances between all data points.}

\item{data}{Data matrix. Each row represents an observation.}
}
\value{
Value of the Bn statistic.
}
\description{
Returns the value for the Bn statistic that measures the degree of separation between two groups.
The statistic is computed through the difference of average within group distances to average between
group distances. Large values of Bn indicate large group separation. Under overall sample homogeneity
we have E(Bn)=0.
}
\details{
Either \code{data} OR \code{md} should be provided.
If data are entered directly, Bn will be computed considering the squared Euclidean distance, which is compatible with
\code{\link{is_homo}}, \code{\link{uclust}} and \code{\link{uhclust}}.

For more detail see Cybis, Gabriela B., Marcio Valk, and Sílvia RC Lopes. "Clustering and classification problems in genetics through U-statistics."
Journal of Statistical Computation and Simulation 88.10 (2018)
and Valk, Marcio, and Gabriela Bettella Cybis. "U-statistical inference for hierarchical clustering." Journal of Computational and Graphical Statistics 30(1) (2021).
}
\examples{
n=5
x=matrix(rnorm(n*10),ncol=10)
bn(c(1,0,0,0,0),data=x)     # option (a) entering the data matrix directly
md=as.matrix(dist(x))^2
bn(c(0,1,1,1,1),md)         # option (b) entering the distance matrix

}
