% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paged_report.R
\name{paged_report}
\alias{paged_report}
\title{Function for UNHCR paged report template}
\usage{
paged_report(
  front_img = NULL,
  img_to_dark = FALSE,
  other_css = NULL,
  toc = TRUE,
  toc_depth = 2,
  number_sections = FALSE,
  ...
)
}
\arguments{
\item{front_img}{Cover image}

\item{img_to_dark}{Darken cover image}

\item{other_css}{Add extra css}

\item{toc}{Table of content}

\item{toc_depth}{Table of content depth}

\item{number_sections}{Number section headings}

\item{...}{Arguments passed to pagedown::html_paged}
}
\value{
An R Markdown output format.
}
\description{
Function for UNHCR paged report template
}
\examples{
\dontrun{
# Requires pandoc

# Create an R Markdown example file
rmd_content <- "---
 title: 'Example UNHCR HTML'
 subtitle: 'Paged Report'
 output: unhcrdown::paged_report
 ---

 ## Introduction

 This is an example of a UNHCR-branded HTML paged report using `unhcrdown::paged_report`.
 "

# Write the R Markdown content to a file
example_file <- tempfile(fileext = ".Rmd")
writeLines(rmd_content, example_file)

# Render the R Markdown file
rmarkdown::render(example_file,
  output_format = unhcrdown::paged_report(),
  output_dir = tempdir()
)

# View the rendered HTML file
browseURL(render_file)
}
}
