% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FU_Berlin.R
\docType{data}
\name{fu_3_2023}
\alias{fu_3_2023}
\title{Blue color gradient of the Free University (FU) Berlin, Germany (pre 2024)}
\format{
An object of class \code{character} of length 10.
}
\source{
Color definitions are based on the \href{https://www.fu-berlin.de/en/index.html}{FU}'s 
\href{https://www.fu-berlin.de/sites/corporate-design/index.html}{Hausfarben} page.
}
\usage{
fu_3_2023
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{fu_3_2023} provides a gradient of the blue primary color  
of the \href{https://www.fu-berlin.de/en/index.html}{Free University Berlin}, Germany.
}
\details{
See \code{\link{fu_0_2023}} for the two primary colors and 
the \code{\link[unikn]{ac}} and \code{\link[unikn]{usecol}} functions for creating 
alternative color gradients.
}
\examples{
fu_3_2023
unikn::seecol(fu_3_2023, main = "Blue color gradient of the FU Berlin")  # view palette

}
\seealso{
\code{\link{fu_1}} to \code{\link{fu_4}} for new colors of the FU Berlin (updated in 2024);
\code{\link[unikn]{seecol}} for viewing and comparing color palettes; 
\code{\link[unikn]{usecol}} for using color palettes; 
\code{\link[unikn]{simcol}} for finding similar colors; 
\code{\link[unikn]{newpal}} for defining new color palettes; 
\code{\link[unikn]{grepal}} for finding named colors.

Other German university color palettes: 
\code{\link{fu_0_2023}},
\code{\link{fu_1}},
\code{\link{fu_1_2023}},
\code{\link{fu_2}},
\code{\link{fu_2_2023}},
\code{\link{fu_3}},
\code{\link{fu_4}},
\code{\link{hu_1}},
\code{\link{hu_1_2022}},
\code{\link{hu_1_digital}},
\code{\link{hu_2}},
\code{\link{hu_2_2022}},
\code{\link{hu_3_accent}},
\code{\link{lmu_1}},
\code{\link{lmu_2}},
\code{\link{lmu_3}},
\code{\link{rptu}},
\code{\link{uni_bonn_1}},
\code{\link{uni_bonn_2}},
\code{\link{uni_freiburg_0}},
\code{\link{uni_freiburg_1}},
\code{\link{uni_freiburg_2}},
\code{\link{uni_freiburg_blue}},
\code{\link{uni_freiburg_br}},
\code{\link{uni_freiburg_grey}},
\code{\link{uni_freiburg_info}},
\code{\link{uni_goettingen_1}},
\code{\link{uni_goettingen_2}},
\code{\link{uni_goettingen_3}},
\code{\link{uni_halle}},
\code{\link{uni_hamburg_1}},
\code{\link{uni_hamburg_2}},
\code{\link{uni_heidelberg}},
\code{\link{uni_jena_1}},
\code{\link{uni_jena_2}},
\code{\link{uni_kassel}},
\code{\link{uni_kiel_1}},
\code{\link{uni_kiel_2}},
\code{\link{uni_koeln_1}},
\code{\link{uni_koeln_2}},
\code{\link{uni_konstanz_1}},
\code{\link{uni_konstanz_2}},
\code{\link{uni_magdeburg_1}},
\code{\link{uni_magdeburg_2}},
\code{\link{uni_magdeburg_3}},
\code{\link{uni_mannheim_1}},
\code{\link{uni_mannheim_2}},
\code{\link{uni_potsdam}},
\code{\link{uni_regensburg_1}},
\code{\link{uni_regensburg_2}},
\code{\link{uni_regensburg_3}},
\code{\link{uni_stuttgart_1}},
\code{\link{uni_stuttgart_print}},
\code{\link{uni_ulm_1}},
\code{\link{uni_ulm_2}}
}
\author{
\strong{unicol}, 2022-12-03.
}
\concept{German university color palettes}
\keyword{datasets}
