% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_script.R
\name{make_script}
\alias{make_script}
\title{Create an empty \code{unifir_script} object.}
\usage{
make_script(
  project,
  script_name = NULL,
  scene_name = NULL,
  unity = find_unity(),
  initialize_project = NULL
)
}
\arguments{
\item{project}{The directory path of the Unity project.}

\item{script_name}{The file name to save the script at. The folder location
and file extensions will be added automatically.}

\item{scene_name}{The default scene to operate within. If a function requires
a scene name and one is not provided, this field will be used.}

\item{unity}{The location of the Unity executable to create projects with.}

\item{initialize_project}{If TRUE, will call \link{create_unity_project} to create
a Unity project at \code{project}. If FALSE, will not create a new project.
If NULL, will create a new project if \code{project} does not exist.}
}
\value{
A \code{unifir_script} object.
}
\description{
unifir relies upon "script" objects, which collect "prop" objects
(C# methods)
which then may be executed within a Unity project via the \link{action} function.
}
\examples{
# Create an empty script file
# In practice, you'll want to set `project` to the project path to create
# and `unity` to `NULL` (the default)
make_script(project = waiver(), unity = waiver())

}
\concept{scripts}
