% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hexahedron.R
\name{runif_in_hexahedron}
\alias{runif_in_hexahedron}
\title{Uniform sampling in a hexahedron}
\usage{
runif_in_hexahedron(n, hexahedron)
}
\arguments{
\item{n}{number of simulations}

\item{hexahedron}{a hexahedron given by a 3 times 8 matrix whose eight 
columns are the vertices; see \code{\link{makeHexahedron}}}
}
\value{
The simulations in a \code{n} times \code{3} matrix.
}
\description{
Uniform sampling in a hexahedron (polyhedron with six faces).
}
\examples{
library(uniformly)
hexahedron <- makeHexahedron(
  p0 = c(0, 0, 0),
  p1 = c(2, 0, 0),
  p2 = c(2, 2, 0),
  p3 = c(0, 2, 0),
  p4 = c(0.5, 1.5, 2),
  p5 = c(0.5, 0.5, 2),
  p6 = c(1.5, 0.5, 2),
  p7 = c(1.5, 1.5, 2)
)
sims <- runif_in_hexahedron(200, hexahedron)
plotHexahedron(hexahedron, alpha = 0.3)
rgl::points3d(sims)
}
