% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniScore.R
\name{uniScore}
\alias{uniScore}
\title{uniScore}
\usage{
uniScore(scores, M = NULL, SD = NULL, b = NULL, corm, method = "composite")
}
\arguments{
\item{scores}{a vector with a person's score from multiple tests}

\item{M}{Vector of means of the tests; must match the order of `scores`. Default: 0}

\item{SD}{Vector of standard deviations of the tests; must match the order of `scores`. Default: 1}

\item{b}{Vector of weightings for the test scores; must match the order of `scores`. Default: 1}

\item{corm}{a matrix that contains the correlations between the tests. There must be ones on the diagonal.}

\item{method}{the specification of the method for computing a unified score. "composite" (default) computes a non-latent unified score and "pca" computes the unified score on the principle component.}
}
\value{
\item{z}{A z score of the class `numeric` corresponding to the unified person's score; M = 0, SD = 1}
  \item{IQ}{An IQ score of the class `numeric` corresponding to the unified person's score; M = 100, SD = 15}
  \item{T}{A T score of the class `numeric` corresponding to the unified person's score; M = 50, SD = 10}
  \item{SW}{A SW score of the class `numeric` corresponding to the unified person's score; M = 100, SD = 10}
  \item{C}{A C score of the class `numeric` corresponding to the unified person's score; M = 5, SD = 2}
  \item{PR}{The percentile rank of the unified person's score of the class `numeric`}
}
\description{
A function for unifying a person's scores from multiple tests
}
\examples{
scores = c(110, 130, 120)
M = c(100, 100, 100)
SD = c(15, 15, 15)
b = c(1, 1, 1)
corm = matrix(c(1, 0.50, 0.35, 0.50, 1, 0.75, 0.35, 0.70, 1), nrow = 3, ncol = 3)
uniScore(scores, M, SD, b, corm, method = "composite")

}
