% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlbeta.R
\name{mlbeta}
\alias{mlbeta}
\title{Beta distribution maximum likelihood estimation}
\usage{
mlbeta(x, na.rm = FALSE, ...)
}
\arguments{
\item{x}{a (non-empty) numeric vector of data values.}

\item{na.rm}{logical. Should missing values be removed?}

\item{...}{Ignored.}
}
\value{
\code{mlbeta} returns an object of \link[base:class]{class}
\code{univariateML}. This is a named numeric vector with maximum
likelihood estimates for \code{shape1} and \code{shape2} and the
following attributes:
\item{\code{model}}{The name of the model.}
\item{\code{density}}{The density associated with the estimates.}
\item{\code{logLik}}{The loglikelihood at the maximum.}
\item{\code{support}}{The support of the density.}
\item{\code{n}}{The number of observations.}
\item{\code{call}}{The call as captured my \code{match.call}}
}
\description{
Uses \code{stat::nlm} to estimate the parameters of the Beta distribution.
}
\details{
For the density function of the Beta distribution see \link[stats:Beta]{Beta}.

For \code{type}, the option \code{none} is fastest.
}
\examples{
AIC(mlbeta(USArrests$Rape / 100))
}
\references{
Johnson, N. L., Kotz, S. and Balakrishnan, N. (1995)
Continuous Univariate Distributions, Volume 2, Chapter 25. Wiley, New York.
}
\seealso{
\link[stats:Beta]{Beta} for the Beta density, \link[stats:nlm]{nlm} for the
optimizer this function uses.
}
