% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mllomax.R
\name{mllomax}
\alias{mllomax}
\title{Lomax distribution maximum likelihood estimation}
\usage{
mllomax(x, na.rm = FALSE, ...)
}
\arguments{
\item{x}{a (non-empty) numeric vector of data values.}

\item{na.rm}{logical. Should missing values be removed?}

\item{...}{\code{lambda0} an optional starting value for the \code{lambda} parameter.
\code{reltol} is the relative accuracy requested,
defaults to \code{.Machine$double.eps^0.25}. \code{iterlim} is a positive integer
specifying the maximum number of iterations to be performed before the
program is terminated (defaults to \code{100}).}
}
\value{
\code{mllomax} returns an object of \link[base:class]{class} \code{univariateML}.
This is a named numeric vector with maximum likelihood estimates for
\code{lambda} and \code{kappa} and the following attributes:
\item{\code{model}}{The name of the model.}
\item{\code{density}}{The density associated with the estimates.}
\item{\code{logLik}}{The loglikelihood at the maximum.}
\item{\code{support}}{The support of the density.}
\item{\code{n}}{The number of observations.}
\item{\code{call}}{The call as captured my \code{match.call}}
}
\description{
Uses Newton-Raphson to estimate the parameters of the Lomax distribution.
}
\details{
For the density function of the Lomax distribution see
\link[extraDistr:Lomax]{Lomax}.

The likelihood estimator of the Lomax distribution is unbounded when \code{mean(x^2) < 2*mean(x)^2}. When this
happens, the likelihood converges to an exponential distribution with parameter
equal to the mean of the data. This is the natural limiting case for the Lomax
distribution, and it is reasonable to use \code{mlexp} in this case.
}
\examples{
set.seed(3)
mllomax(extraDistr::rlomax(100, 2, 4))

# The maximum likelihood estimator may fail if the data is exponential.
\dontrun{
set.seed(5)
mllomax(rexp(10))
}
}
\references{
Kleiber, Christian; Kotz, Samuel (2003), Statistical Size
Distributions in Economics and Actuarial Sciences, Wiley Series in
Probability and Statistics, 470, John Wiley & Sons, p. 60
}
\seealso{
\link[extraDistr:Lomax]{Lomax} for the Lomax density.
}
