% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/um.test2.R
\name{um.test2}
\alias{um.test2}
\title{Test of Mediation Effects Between Two Objects}
\usage{
um.test2 (obj1, obj2, scale = "RD", type = c("PNDE", "TNIE"), Cf_lv=0.95, verbose=TRUE)
}
\arguments{
\item{obj1}{a resulting object of class \code{"unvs.med"}
from function \code{\link{FormalEstmed}}.}

\item{obj2}{a resulting object of class \code{"unvs.med"}
from function \code{\link{FormalEstmed}}.}

\item{scale}{a character variable of the effect scales. It can be \code{"RD"}, \code{"OR"} or \code{"RR"}.
The default is \code{"RD"}.}

\item{type}{a character variable of the effect types, containing more than two.
The default is \code{c("PNDE", "TNIE")}.}

\item{Cf_lv}{a numeric variable of the confident interval.
The default is 0.95.}

\item{verbose}{a logical value indicating whether the output is display. The default is TRUE.
This is a standard parameter required by CRAN.}
}
\value{
No return value, called for displaying the output of the test result.
}
\description{
This function tests the difference of various types of effects between
two estimation objects from function \code{\link{FormalEstmed}}. It
is used to compare whether an effect is distinct from another between two
different estimation settings.
}
\examples{
\donttest{
# Running formal estimation
data(testdata)
med_model=glm(med~exp+exp*C1+C2+C3, data=testdata, family=binomial) # Fitting mediator's model
out_model=lm(out~med*exp+exp*C1+C2+C3, data=testdata) # Fitting outcome's model
r1 = FormalEstmed (med_model=med_model, out_model=out_model,
data=testdata, exposure = "exp", cov_val="C1==1") # Conditioning on C1=1
r0 = FormalEstmed (med_model=med_model, out_model=out_model,
data=testdata, exposure = "exp", cov_val="C1==0") # Conditioning on C1=0

# Test examples
um.test2(r1,r0) # Test of the default settings (PNDE v.s. TNIE on RD scales).
um.test2(r1,r0, c("OR", "RR")) # Test of PNDE v.s. TNIE on OR and RR scales.
# Test of PNDE v.s. TNIE v.s. TE on OR and RR scales:
um.test2(r1,r0, c("OR", "RR"), c("PNDE", "TNIE", "TE"))
# Test of PNDE v.s. TNIE v.s. TE on OR and RR scales with 90\% CI:
um.test2(r1,r0, c("OR", "RR"), c("PNDE", "TNIE", "TE"), Cf_lv=0.9)
}
}
