% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{encoding}
\alias{encoding}
\alias{url_encoder}
\alias{url_decoder}
\title{Escape characters for use in URLs.}
\usage{
url_encoder(urls, safe = "")

url_decoder(urls)
}
\arguments{
\item{urls}{A character vector to be encoded/decoded.}

\item{safe}{A character vector of extra characters that should not be encoded.}
}
\value{
A character vector with the encoded URLs.
}
\description{
This function encodes a character vector for use in URLs, escaping all special characters
except for those specified in the \code{safe} parameter.
}
\examples{
library(urlparse)

# Example 1:
url_encoder("foo = bar + 5")

# Example 2:
# prevent special characters being encoded:
url <- "https://example.com/path?query= 1+2"
url_encoder(url, ":/?=")

# Example 3:
url_decoder(url_encoder("foo = bar + 5"))

}
