% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_table.R
\name{build_table.coxph}
\alias{build_table.coxph}
\title{Build summary tables from coxph model objects}
\usage{
\method{build_table}{coxph}(
  .object,
  ...,
  .test = c("LRT", "Wald"),
  .col.test = FALSE,
  .level = 0.95,
  .stat.pct.sign = TRUE,
  .digits = 1,
  .p.digits = 4
)
}
\arguments{
\item{.object}{An object of class \code{\link[survival]{coxph}}.}

\item{...}{One or more unquoted expressions separated by commas representing
columns in the data.frame. May be specified using
\code{\link[tidyselect:select_helpers]{tidyselect helpers}}. If left empty,
all terms are summarized.}

\item{.test}{A character. The name of the
\code{\link[stats:add1]{stats::drop1}} test to use with the model. Supported
tests include Wald's Test ('Wald') and Likelihood Ratio Test ('LRT').}

\item{.col.test}{A logical. Append a columns for the test and accompanying
statistic used to derive the p-value.}

\item{.level}{A double. The confidence level required.}

\item{.stat.pct.sign}{A logical. Paste a percent symbol after all reported
frequencies.}

\item{.digits}{An integer. The number of digits to round numbers to.}

\item{.p.digits}{An integer. The number of p-value digits to report. Note
that the p-value still rounded to the number of digits specified in
\code{.digits}.}
}
\value{
An object of class \code{tbl_df} (tibble) summarizing the provided
object.
}
\description{
Takes a Cox PH model object and summarizes it into a ready to
export, human-readable summary table.
}
\examples{
library(survival)
library(dplyr)

data_lung <- lung |>
  mutate_at(vars(inst, status, sex), as.factor) |>
  mutate(status = case_when(status == 1 ~ 0, status == 2 ~ 1))

fit <- coxph(Surv(time, status) ~ sex + meal.cal, data = data_lung)

fit |> build_table(Sex = sex, Calories = meal.cal, .test = 'LRT')
}
\seealso{
\code{\link{build_table}}
}
