% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paste.R
\name{paste_freq}
\alias{paste_freq}
\title{Paste frequency}
\usage{
paste_freq(x, y, na.rm = TRUE, percent.sign = TRUE, digits = 1)
}
\arguments{
\item{x}{A data.frame, numeric, or non-numeric. The numerator.}

\item{y}{A data.frame, numeric, or non-numeric. The denominator. A single
denominator may be used for multiple numerators or one denominator for each
numerator.}

\item{na.rm}{A logical. Whether to ignore NA's when tallying non-numeric data.}

\item{percent.sign}{A logical. Indicates percent sign should be printed
with frequencies.}

\item{digits}{An integer. Number of digits to round to.}
}
\value{
A character vector of count(s) with frequencies.
}
\description{
Creates a formatted frequency from count(able) data. Automatically
tallies non-numeric data types (nrow or length) and supports vectorized data
methods.
}
\examples{
# Numeric
paste_freq(20, 100)

# data.frame
df <- data.frame(x = c(1:100), y = TRUE)
paste_freq(df[1:20,], df)

# Mixed data types
paste_freq(20, df)

# Single denominator for multiple numerators
paste_freq(c(10,20,30), 100)
}
