% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/a_qnorm.R
\name{a_qnorm}
\alias{a_qnorm}
\title{Returns the typical value from a unit-normal distribution}
\usage{
a_qnorm(i, n)
}
\arguments{
\item{i}{Non-zero index of an array}

\item{n}{Non-zero length of the array}
}
\value{
Quantile of \code{i} from a unit-normal distribution
}
\description{
Returns the typical value from a unit-normal distribution for the
\emph{i}th ordered observation in an \emph{n}-sized sample.

This is a helper function for FUNOP, which uses the output of this
function as the denominator for its slope calculation.
}
\examples{
a_qnorm(i = 25, n = 42)
a_qnorm(21.5, 42)
}
\references{
Tukey, John W. "The Future of Data Analysis."
\emph{The Annals of Mathematical Statistics},
\emph{33}(1), 1962, pp 1-67. \emph{JSTOR},
\url{https://www.jstor.org/stable/2237638}.
}
\seealso{
\code{\link[=funop]{funop()}}
}
