% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checklist.R
\name{checklist}
\alias{checklist}
\alias{is_check_formula}
\alias{is_checklist}
\title{Is a formula a check formula?}
\usage{
is_check_formula(x)

is_checklist(x)
}
\arguments{
\item{x}{Object to test.}
}
\value{
\code{is_check_formula}, resp. \code{is_checklist}, returns
\code{TRUE} or \code{FALSE}, according to whether \code{x} is or is not a
check formula, resp. checklist.
}
\description{
\code{is_check_formula(x)} checks whether \code{x} is a check formula, while
\code{is_checklist(x)} checks whether \code{x} is a \emph{checklist}, i.e., a
list of check formulae. (Neither function verifies logical consistency of the
implied checks.)
}
\examples{
is_check_formula(list(~x, ~y) ~ is.numeric)  # [1] TRUE
is_check_formula("Not positive" ~ {. > 0})   # [1] TRUE

is_checklist(list(list(~x, ~y) ~ is.numeric, "Not positive" ~ {. > 0}))
# [1] TRUE

# Invalid checklists
is_checklist("Not positive" ~ {. > 0})            # [1] FALSE (not a list)
is_checklist(list(is.numeric ~ list(~ x)))        # [1] FALSE (backwards)
is_checklist(list(list(log ~ x) ~ is.character))  # [1] FALSE (invalid check item)

}
\seealso{
\link{firmly} (on the specification and use of check formulae)
}
