% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vl_isochrone.R
\name{vl_isochrone}
\alias{vl_isochrone}
\title{Get isochrones and isodistances from a point}
\usage{
vl_isochrone(
  loc,
  times,
  distances,
  costing = "auto",
  costing_options = list(),
  server = getOption("valh.server")
)
}
\arguments{
\item{loc}{one point from which to compute isochrones.
\code{loc} can be: \itemize{
  \item a vector of coordinates (longitude and latitude, WGS 84),
  \item a data.frame of longitudes and latitudes (WGS 84),
  \item a matrix of longitudes and latitudes (WGS 84),
  \item an sfc object of type POINT,
  \item an sf object of type POINT.
}}

\item{times}{vector of travel times (in minutes) to compute the
isochrones. The maximum number of isochrones is 4. The minimal value must
be greater than 0.}

\item{distances}{vector of travel distances (in kilometers) to compute the
isochrones. The maximum number of isochrones is 4. The minimal value must
be greater than 0.}

\item{costing}{costing model to use.}

\item{costing_options}{list of options to use with the costing model
(see \url{https://valhalla.github.io/valhalla/api/turn-by-turn/api-reference/#costing-options}
for more details about the options available for each costing model).}

\item{server}{URL of the Valhalla server.}
}
\value{
An sf MULTIPOLYGON object is returned with the following fields:
'metric' (the metric used, either 'time' or 'distance')
and 'contour' (the value of the metric).
}
\description{
Build and send a Valhalla API query to get isochrones or
isodistances from a point.\cr
This function interfaces with the \emph{Isochrone & Isodistance} service.\cr
Note that you must provide either 'times' or 'distances' to compute the isochrones
at given times or distances from the center point.
}
\examples{
\dontrun{
# Inputs are data frames
apotheke.df <- read.csv(system.file("csv/apotheke.csv", package = "valh"))

# Extract the first point and compute isochrones at 3, 6, 9 and 12 kilometers,
# using the "auto" costing model
pt1 <- apotheke.df[1, c("lon", "lat")]
iso1 <- vl_isochrone(loc = pt1, distances = c(3, 6, 9, 12), costing = "auto")

# Inputs are sf points
library(sf)
apotheke.sf <- st_read(system.file("gpkg/apotheke.gpkg", package = "valh"),
  quiet = TRUE
)
# Extract the first point and compute isochrones at 15, 30, 45 and 60 minutes
# using the "bicycle" costing model
pt2 <- apotheke.sf[1, ]
iso2 <- vl_isochrone(loc = pt2, times = c(15, 30, 45, 60), costing = "bicycle")
}
}
