% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vl_matrix.R
\name{vl_matrix}
\alias{vl_matrix}
\title{Get Travel Time Matrices Between Points}
\usage{
vl_matrix(
  src,
  dst,
  loc,
  costing = "auto",
  costing_options = list(),
  server = getOption("valh.server")
)
}
\arguments{
\item{src}{origin points.
\code{src} can be: \itemize{
  \item a data.frame of longitudes and latitudes (WGS 84),
  \item a matrix of longitudes and latitudes (WGS 84),
  \item an sfc object of type POINT,
  \item an sf object of type POINT.
}
If relevant, row names are used as identifiers.}

\item{dst}{destination.
\code{dst} can be: \itemize{
  \item a data.frame of longitudes and latitudes (WGS 84),
  \item a matrix of longitudes and latitudes (WGS 84),
  \item an sfc object of type POINT,
  \item an sf object of type POINT.
}
If relevant, row names are used as identifiers.}

\item{loc}{points. \code{loc} can be: \itemize{
  \item a data.frame of longitudes and latitudes (WGS 84),
  \item a matrix of longitudes and latitudes (WGS 84),
  \item an sfc object of type POINT,
  \item an sf object of type POINT.
}
If relevant, row names are used as identifiers.}

\item{costing}{costing model to use.}

\item{costing_options}{list of options to use with the costing model
(see \url{https://valhalla.github.io/valhalla/api/turn-by-turn/api-reference/#costing-options}
for more details about the options available for each costing model).}

\item{server}{URL of the Valhalla server.}
}
\value{
The output of this function is a list composed of one or two matrices
and 2 data.frames
\itemize{
  \item{durations}: a matrix of travel times (in minutes)
  \item{distances}: a matrix of distances (in specified units, default to
  kilometers)
  \item{sources}: a data.frame of the coordinates of the points actually
  used as starting points (EPSG:4326 - WGS84)
  \item{destinations}: a data.frame of the coordinates of the points actually
  used as destinations (EPSG:4326 - WGS84)
  }
}
\description{
Build and send Valhalla API queries to get travel time matrices
between points.\cr
This function interfaces the \emph{matrix} Valhalla service.\cr
Use \code{src} and \code{dst} to set different origins and destinations.
Use \code{loc} to compute travel times or travel distances between all
points.
}
\examples{
\dontrun{
# Inputs are data frames
apotheke.df <- read.csv(system.file("csv/apotheke.csv", package = "valh"))
# Travel time matrix
distA <- vl_matrix(loc = apotheke.df[1:50, c("lon", "lat")])
# First 5 rows and columns
distA$durations[1:5, 1:5]

# Travel time matrix with different sets of origins and destinations
distA2 <- vl_matrix(
  src = apotheke.df[1:10, c("lon", "lat")],
  dst = apotheke.df[11:20, c("lon", "lat")]
)
# First 5 rows and columns
distA2$durations[1:5, 1:5]

# Inputs are sf points
library(sf)
apotheke.sf <- st_read(system.file("gpkg/apotheke.gpkg", package = "valh"),
  quiet = TRUE
)
distA3 <- vl_matrix(loc = apotheke.sf[1:10, ])
# First 5 rows and columns
distA3$durations[1:5, 1:5]

# Travel time matrix with different sets of origins and destinations
distA4 <- vl_matrix(src = apotheke.sf[1:10, ], dst = apotheke.sf[11:20, ])
# First 5 rows and columns
distA4$durations[1:5, 1:5]
}
}
