% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vl_route.R
\name{vl_route}
\alias{vl_route}
\title{Get the Shortest Path Between Two Points}
\usage{
vl_route(
  src,
  dst,
  loc,
  costing = "auto",
  costing_options = list(),
  server = getOption("valh.server")
)
}
\arguments{
\item{src}{starting point of the route.
\code{src} can be: \itemize{
  \item a vector of coordinates (longitude and latitude, WGS 84),
  \item a data.frame of longitudes and latitudes (WGS 84),
  \item a matrix of longitudes and latitudes (WGS 84),
  \item an sfc object of type POINT,
  \item an sf object of type POINT.
}
If relevant, row names are used as identifiers.\cr
If \code{src} is a data.frame, a matrix, an sfc object or an sf object then
only the first row or element is considered.}

\item{dst}{destination of the route.
\code{dst} can be: \itemize{
  \item a vector of coordinates (longitude and latitude, WGS 84),
  \item a data.frame of longitudes and latitudes (WGS 84),
  \item a matrix of longitudes and latitudes (WGS 84),
  \item an sfc object of type POINT,
  \item an sf object of type POINT.
}
If relevant, row names are used as identifiers.\cr
If \code{dst} is a data.frame, a matrix, an sfc object or an sf object then
only the first row or element is considered.}

\item{loc}{starting point, waypoints (optional) and destination of the
route. \code{loc} can be: \itemize{
  \item a data.frame of longitudes and latitudes (WGS 84),
  \item a matrix of longitudes and latitudes (WGS 84),
  \item an sfc object of type POINT,
  \item an sf object of type POINT.
}
The first row or element is the starting point then waypoints are used in
the order they are stored in \code{loc} and the last row or element is
the destination.\cr
If relevant, row names are used as identifiers.}

\item{costing}{costing model to use.}

\item{costing_options}{list of options to use with the costing model
(see \url{https://valhalla.github.io/valhalla/api/turn-by-turn/api-reference/#costing-options}
for more details about the options available for each costing model).}

\item{server}{URL of the Valhalla server.}
}
\value{
The output of this function is an sf LINESTRING of the shortest route.\cr
It contains 4 fields: \itemize{
  \item starting point identifier
  \item destination identifier
  \item travel time in minutes
  \item travel distance in kilometers.
  }
}
\description{
Build and send a Valhalla API query to get the travel geometry
between two points.\cr
This function interfaces with the \emph{route} Valhalla service.\cr
Use \code{src} and \code{dst} to get the shortest direct route between
two points. Use \code{loc} to get the shortest route between two points using
ordered waypoints.
}
\examples{
\dontrun{
# Inputs are data frames
apotheke.df <- read.csv(system.file("csv/apotheke.csv", package = "valh"))
src <- apotheke.df[1, c("lon", "lat")]
dst <- apotheke.df[2, c("lon", "lat")]
# Route between the two points, using bicycle costing model
route1 <- vl_route(src = src, dst = dst, costing = "bicycle")

# Inputs are sf points
library(sf)
apotheke.sf <- st_read(system.file("gpkg/apotheke.gpkg", package = "valh"),
  quiet = TRUE
)
srcsf <- apotheke.sf[1, ]
dstsf <- apotheke.sf[2, ]
# Route between the two points, using bicycle costing model and a custom
# costing option
route2 <- vl_route(
  src = srcsf,
  dst = dstsf,
  costing = "bicycle",
  costing_options = list(cycling_speed = 19)
)
}
}
