% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{cash.5.2xday}
\alias{cash.5.2xday}
\title{Cash 5 (twice daily)}
\format{A data frame with 11,164 rows and 7 variables:
\describe{
  \item{date}{date of draw}
  \item{time}{time of drawing: day or night}
  \item{N1}{1st number in order}
  \item{N2}{2nd number in order}
  \item{N3}{3rd number in order}
  \item{N4}{4th number in order}
  \item{N5}{5th number in order}
}}
\source{
\url{https://www.valottery.com}
}
\usage{
cash.5.2xday
}
\description{
Historical data for the Cash 5 twice daily game. Game Play: Pick five
numbers from 1 through 34. Note: On April 11, 1999, Cash 5 switched
to twice daily drawings.
}
\examples{
max.days <- apply(subset(cash.5.2xday,time=="day",-(1:2)),1,max)
max.nights <- apply(subset(cash.5.2xday,time=="night",-(1:2)),1,max)
op <- par(mfrow=c(1,2))
hist(max.days)
hist(max.nights)
par(op)
}
\keyword{datasets}

